@extends('layouts.invoice')

@section('content')
<section>
	<div class="card elevation-0 mb-0">
		<div class="card-body p-0">
			<div class="row">
				<div class="col-12">
					<div class="table-responsive">
						<table class="table table-bordered table-striped mb-0 ">
							<thead>
								<tr>
									<th>{{ __('reports.th_reg_no') }}</th>
									<th>{{ __('reports.th_name') }}</th>
									<th>{{ __('reports.th_date') }}</th>
									<th>{{ __('reports.th_day') }}</th>
									<th>{{ __('reports.th_status') }}</th>
									<th>{{ __('reports.th_taken_by') }}</th>
								</tr>
							</thead>
							<tbody>
								@foreach($attendances as $attendance)
								<tr>
									<td class="align-middle">{{ $attendance->member->reg_no }}</td>
									<td class="align-middle">{{ $attendance->member->name }}</td>
									<td class="align-middle ">{{ format_date($attendance->attendance_date) }}</td>
									<td class="">{{ day_name($attendance->attendance_date) }}</td>
									<td class="align-middle">{{ $attendance->status }}</td>
									<td class="align-middle">{{ $attendance->user->name }}</td>
								</tr>
								@endforeach

								@if(count($attendances) == 0)
								<tr>
									<td colspan="11">
										<p class="text-center text-muted mb-0">No Record Found</p>
									</td>
								</tr>
								@endif
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection

@section('js-script')
<script>
	window.addEventListener("load", window.print());
</script>
@endsection